/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.config.CommonValueMapper;
import io.github.noeppi_noeppi.libx.config.Config;
import io.github.noeppi_noeppi.libx.config.ConfigValidator;
import io.github.noeppi_noeppi.libx.config.GenericValueMapper;
import io.github.noeppi_noeppi.libx.config.Group;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.gui.ModConfigGuiAdapter;
import io.github.noeppi_noeppi.libx.impl.config.mappers.SimpleValueMappers;
import io.github.noeppi_noeppi.libx.impl.config.mappers.advanced.ComponentValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.advanced.IngredientStackValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.advanced.IngredientValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.advanced.ResourceListValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.advanced.ResourceValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.advanced.UidValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.generic.ListValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.generic.MapValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.generic.OptionValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.special.EnumValueMappers;
import io.github.noeppi_noeppi.libx.impl.config.mappers.special.PairValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.special.RecordValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.mappers.special.TripleValueMapper;
import io.github.noeppi_noeppi.libx.impl.config.validators.SimpleValidators;
import io.github.noeppi_noeppi.libx.impl.config.wrapper.JsonTypesafeMapper;
import io.github.noeppi_noeppi.libx.impl.config.wrapper.WrappedGenericMapper;
import io.github.noeppi_noeppi.libx.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.api.distmarker.OnlyIns;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ModMappers {
    private static final Map<String, ModMappers> modMappers = new HashMap<String, ModMappers>();
    private static final Map<Class<?>, CommonValueMapper<?, ?>> globalMappers = (Map)Stream.of(SimpleValueMappers.BOOLEAN, SimpleValueMappers.BYTE, SimpleValueMappers.SHORT, SimpleValueMappers.INTEGER, SimpleValueMappers.LONG, SimpleValueMappers.FLOAT, SimpleValueMappers.DOUBLE, SimpleValueMappers.STRING, OptionValueMapper.INSTANCE, ListValueMapper.INSTANCE, MapValueMapper.INSTANCE, ResourceValueMapper.INSTANCE, IngredientValueMapper.INSTANCE, ComponentValueMapper.INSTANCE, ResourceListValueMapper.INSTANCE, IngredientStackValueMapper.INSTANCE, UidValueMapper.INSTANCE).collect(ImmutableMap.toImmutableMap(CommonValueMapper::type, Function.identity()));
    private static final Map<Class<? extends Annotation>, ConfigValidator<?, ?>> globalValidators = (Map)Stream.of(SimpleValidators.SHORT, SimpleValidators.INTEGER, SimpleValidators.LONG, SimpleValidators.FLOAT, SimpleValidators.DOUBLE).collect(ImmutableMap.toImmutableMap(ConfigValidator::annotation, Function.identity()));
    private final String modid;
    private final Map<Class<?>, CommonValueMapper<?, ?>> mappers = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends Annotation>, ConfigValidator<?, ?>> validators = Collections.synchronizedMap(new HashMap());
    private ModConfigGuiAdapter adapter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModMappers get(String modid) {
        Map<String, ModMappers> map = modMappers;
        synchronized (map) {
            if (!modMappers.containsKey(modid)) {
                modMappers.put(modid, new ModMappers(modid));
            }
            return modMappers.get(modid);
        }
    }

    private ModMappers(String modid) {
        this.modid = modid;
    }

    public void registerValueMapper(ValueMapper<?, ?> mapper) {
        this.doRegisterValueMapper(mapper);
    }

    public void registerValueMapper(GenericValueMapper<?, ?, ?> mapper) {
        this.doRegisterValueMapper(mapper);
    }

    private void doRegisterValueMapper(CommonValueMapper<?, ?> mapper) {
        if (this.mappers.containsKey(mapper.type())) {
            throw new IllegalStateException("Config mapper for type '" + mapper.type() + "' is already registered.");
        }
        if (globalMappers.containsKey(mapper.type())) {
            LibX.logger.warn(this.modid + " registers a custom value mapper for type " + mapper.type() + " even if there's a builtin one. This is discouraged.");
        }
        this.mappers.put(mapper.type(), mapper);
    }

    public void registerConfigValidator(ConfigValidator<?, ?> validator) {
        if (this.validators.containsKey(validator.annotation())) {
            throw new IllegalStateException("Config validator for annotation '" + validator.annotation() + "' is already registered.");
        }
        if (globalValidators.containsKey(validator.annotation())) {
            throw new IllegalStateException("Config validator for annotation '" + validator.annotation() + "' is global, can't be changed. Add your own annotation.");
        }
        this.validators.put(validator.annotation(), validator);
    }

    public ValueMapper<?, ?> getMapper(Field field) {
        return this.getMapper(field.getGenericType());
    }

    private ValueMapper<?, ?> getMapper(Type type) {
        Class<?> cls = ClassUtil.boxed(ModMappers.getTypeClass(type));
        if (cls.isEnum()) {
            return EnumValueMappers.getMapper(cls);
        }
        if (cls == Pair.class) {
            return new PairValueMapper<Object, Object>(this.getWrappedMapperUnsafe(type, 0), this.getWrappedMapperUnsafe(type, 1));
        }
        if (cls == Triple.class) {
            return new TripleValueMapper<Object, Object, Object>(this.getWrappedMapperUnsafe(type, 0), this.getWrappedMapperUnsafe(type, 1), this.getWrappedMapperUnsafe(type, 2));
        }
        if (cls.isRecord()) {
            return new RecordValueMapper(cls, this::getMapper);
        }
        CommonValueMapper<?, ?> mapper = null;
        if (this.mappers.containsKey(cls)) {
            mapper = this.mappers.get(cls);
        } else if (globalMappers.containsKey(cls)) {
            mapper = globalMappers.get(cls);
        }
        if (mapper instanceof ValueMapper) {
            ValueMapper valueMapper = (ValueMapper)mapper;
            return valueMapper;
        }
        if (mapper instanceof GenericValueMapper) {
            GenericValueMapper genericMapper = (GenericValueMapper)mapper;
            if (!(type instanceof ParameterizedType)) {
                throw new IllegalStateException("Generic value mapper used on type without generics.");
            }
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (args.length <= genericMapper.getGenericElementPosition()) {
                throw new IllegalStateException("Generic value mapper used on type with too less generics: Expected at least " + (genericMapper.getGenericElementPosition() + 1) + ", got " + args.length);
            }
            ValueMapper<Object, JsonElement> childMapper = this.getWrappedMapperUnsafe(type, genericMapper.getGenericElementPosition());
            return new WrappedGenericMapper(genericMapper, childMapper);
        }
        throw new IllegalStateException("No config mapper found for type " + type + " (" + cls + ")");
    }

    private ValueMapper<Object, JsonElement> getWrappedMapperUnsafe(Type type, int genericPosition) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException("Generic value mapper used on type without generics.");
        }
        Type[] args = ((ParameterizedType)type).getActualTypeArguments();
        if (args.length <= genericPosition) {
            throw new IllegalStateException("Generic value mapper used on type with too less generics: Expected at least " + (genericPosition + 1) + ", got " + args.length);
        }
        ValueMapper<?, ?> mapper = this.getMapper(args[genericPosition]);
        return new JsonTypesafeMapper<Object>(mapper);
    }

    private static Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return ModMappers.getTypeClass(ptype.getRawType());
        }
        if (type instanceof TypeVariable) {
            throw new IllegalStateException("Type variables are not allowed in config field types.");
        }
        if (type instanceof WildcardType) {
            throw new IllegalStateException("Wildcard types are not allowed in config field types.");
        }
        throw new IllegalStateException("Unknown declared type of config field: " + type);
    }

    @Nullable
    public <A extends Annotation> ConfigValidator<?, A> getValidatorByAnnotation(Class<A> validatorClass) {
        if (Config.class.isAssignableFrom(validatorClass) || Group.class.isAssignableFrom(validatorClass) || OnlyIn.class.isAssignableFrom(validatorClass) || OnlyIns.class.isAssignableFrom(validatorClass)) {
            return null;
        }
        Optional<ConfigValidator> validator = globalValidators.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(validatorClass)).map(Map.Entry::getValue).findFirst();
        if (validator.isPresent()) {
            return validator.get();
        }
        validator = this.validators.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(validatorClass)).map(Map.Entry::getValue).findFirst();
        return validator.orElse(null);
    }

    public void initAdapter(ModLoadingContext context) {
        if (this.adapter == null && FMLEnvironment.dist == Dist.CLIENT) {
            this.adapter = new ModConfigGuiAdapter(this.modid, context.getActiveContainer());
        }
    }

    public void configRegistered() {
        if (this.adapter != null) {
            this.adapter.checkRegister();
        }
    }
}

